@extends('layouts.admin')

@section('title', 'Blog Posts')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Blog Posts</h1>
    <a href="{{ route('admin.blogs.create') }}" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Add New Post
    </a>
</div>

<div class="card">
    <div class="card-body">
        @if($blogs->count() > 0)
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Featured Image</th>
                        <th>Title</th>
                        <th>Author</th>
                        <th>Published</th>
                        <th>Views</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($blogs as $blog)
                    <tr>
                        <td>
                            @if($blog->featured_image)
                                <img src="{{ asset('storage/' . $blog->featured_image) }}" alt="{{ $blog->title }}" style="width: 60px; height: 60px; object-fit: cover; border-radius: 4px;">
                            @else
                                <i class="bi bi-image" style="font-size: 2rem; color: #ccc;"></i>
                            @endif
                        </td>
                        <td>{{ $blog->title }}</td>
                        <td>{{ $blog->author ?? 'Admin' }}</td>
                        <td>{{ $blog->published_at ? $blog->published_at->format('M d, Y') : 'Not set' }}</td>
                        <td>{{ $blog->views }}</td>
                        <td>
                            <span class="badge bg-{{ $blog->is_published ? 'success' : 'secondary' }}">
                                {{ $blog->is_published ? 'Published' : 'Draft' }}
                            </span>
                        </td>
                        <td>
                            <a href="{{ route('admin.blogs.show', $blog) }}" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            <a href="{{ route('admin.blogs.edit', $blog) }}" class="btn btn-sm btn-warning">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <form action="{{ route('admin.blogs.destroy', $blog) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this blog post?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <p class="text-muted mb-0">No blog posts yet. <a href="{{ route('admin.blogs.create') }}">Create your first post</a>.</p>
        @endif
    </div>
</div>
@endsection



